// mdName.java
//
// Melissa Data Address Object for Windows/Linux/Unix
// Copyright 1993-2007 Melissa Data Corporation.
//
// Public Java interface
//
// PRELIMINARY VERSION SUBJECT TO CHANGES

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************


package mdName;

public class mdName {
	// ProgramStatus (returned by InitializeDataFiles):
	public static final int NoError=0;
	public static final int ConfigFile=1;
	public static final int LicenseExpired=2;
	public static final int DatabaseExpired=3;
	public static final int Unknown=4;

	// NameHints (input to SetPrimaryNameHint & SetSecondaryNameHint):
	public static final int DefinitelyFull=1;
	public static final int VeryLikelyFull=2;
	public static final int ProbablyFull=3;
	public static final int Varying=4;
	public static final int ProbablyInverse=5;
	public static final int VeryLikelyInverse=6;
	public static final int DefinitelyInverse=7;
	public static final int MixedFirstName=8;
	public static final int MixedLastName=9;

	// Population (input to SetGenderPopulation):
	public static final int Male=1;
	public static final int Mixed=2;
	public static final int Female=3;

	// Aggression (input to SetGenderAggression):
	public static final int Aggressive=1;
	public static final int Neutral=2;
	public static final int Conservative=3;

	// Salutations (input to AddSalutation):
	public static final int Formal=0;
	public static final int Informal=1;
	public static final int FirstLast=2;
	public static final int Slug=3;
	public static final int Blank=4;

	private long I;

	private native static long mdCreate();
	private native static void mdDestroy(long I);
	private native static void mdSetPathToNameFiles(long I,String Path);
	private native static int mdInitializeDataFiles(long I);
	private native static String mdGetInitializeErrorString(long I);
	private native static int mdSetLicenseString(long I,String License);
	private native static String mdGetBuildNumber(long I);
	private native static String mdGetDatabaseDate(long I);
	private native static String mdGetDatabaseExpirationDate(long I);
	private native static String mdGetLicenseExpirationDate(long I);
	private native static int mdSetPrimaryNameHint(long I,int NameHint);
	private native static int mdSetSecondaryNameHint(long I,int NameHint);
	private native static int mdSetFirstNameSpellingCorrection(long I,int Status);
	private native static int mdSetGenderPopulation(long I,int Population);
	private native static int mdSetGenderAggression(long I,int Aggression);
	private native static int mdAddSalutation(long I,int Salutation);
	private native static void mdSetSalutationPrefix(long I,String Prefix);
	private native static void mdSetSalutationSuffix(long I,String Suffix);
	private native static void mdSetSalutationSlug(long I,String Slug);
	private native static void mdClearProperties(long I);
	private native static void mdSetFullName(long I,String FullName);
	private native static void mdSetPrefix(long I,String Prefix);
	private native static void mdSetPrefix2(long I,String Prefix);
	private native static void mdSetFirstName(long I,String First);
	private native static void mdSetFirstName2(long I,String First);
	private native static void mdSetMiddleName(long I,String Middle);
	private native static void mdSetMiddleName2(long I,String Middle);
	private native static void mdSetLastName(long I,String Last);
	private native static void mdSetLastName2(long I,String Last);
	private native static void mdSetSuffix(long I,String Suffix);
	private native static void mdSetSuffix2(long I,String Suffix);
	private native static int mdParse(long I);
	private native static int mdGenderize(long I);
	private native static int mdSalutate(long I);
	private native static String mdGetStatusCode(long I);
	private native static String mdGetErrorCode(long I);
	private native static String mdGetChangeCode(long I);
	private native static String mdGetPrefix(long I);
	private native static String mdGetPrefix2(long I);
	private native static String mdGetFirstName(long I);
	private native static String mdGetFirstName2(long I);
	private native static String mdGetMiddleName(long I);
	private native static String mdGetMiddleName2(long I);
	private native static String mdGetLastName(long I);
	private native static String mdGetLastName2(long I);
	private native static String mdGetSuffix(long I);
	private native static String mdGetSuffix2(long I);
	private native static String mdGetGender(long I);
	private native static String mdGetGender2(long I);
	private native static String mdGetSalutation(long I);

	public mdName() {
		System.loadLibrary("mdName");
		I=mdCreate();
	}

	public void finalize() {
		mdDestroy(I);
	}

	public void SetPathToNameFiles(String Path) {
		mdSetPathToNameFiles(I,Path);
	}

	public int InitializeDataFiles() {
		return mdInitializeDataFiles(I);
	}

	public String GetInitializeErrorString() {
		return mdGetInitializeErrorString(I);
	}

	public int SetLicenseString(String License) {
		return mdSetLicenseString(I,License);
	}

	public String GetBuildNumber() {
		return mdGetBuildNumber(I);
	}

	public String GetDatabaseDate() {
		return mdGetDatabaseDate(I);
	}

	public String GetDatabaseExpirationDate() {
		return mdGetDatabaseExpirationDate(I);
	}

	public String GetLicenseExpirationDate() {
		return mdGetLicenseExpirationDate(I);
	}

	public int SetPrimaryNameHint(int NameHint) {
		return mdSetPrimaryNameHint(I,NameHint);
	}

	public int SetSecondaryNameHint(int NameHint) {
		return mdSetSecondaryNameHint(I,NameHint);
	}

	public int SetFirstNameSpellingCorrection(int Status) {
		return mdSetFirstNameSpellingCorrection(I,Status);
	}

	public int SetGenderPopulation(int Population) {
		return mdSetGenderPopulation(I,Population);
	}

	public int SetGenderAggression(int Aggression) {
		return mdSetGenderAggression(I,Aggression);
	}

	public int AddSalutation(int Salutation) {
		return mdAddSalutation(I,Salutation);
	}

	public void SetSalutationPrefix(String Prefix) {
		mdSetSalutationPrefix(I,Prefix);
	}

	public void SetSalutationSuffix(String Suffix) {
		mdSetSalutationSuffix(I,Suffix);
	}

	public void SetSalutationSlug(String Slug) {
		mdSetSalutationSlug(I,Slug);
	}

	public void ClearProperties() {
		mdClearProperties(I);
	}

	public void SetFullName(String FullName) {
		mdSetFullName(I,FullName);
	}

	public void SetPrefix(String Prefix) {
		mdSetPrefix(I,Prefix);
	}

	public void SetPrefix2(String Prefix) {
		mdSetPrefix2(I,Prefix);
	}

	public void SetFirstName(String First) {
		mdSetFirstName(I,First);
	}

	public void SetFirstName2(String First) {
		mdSetFirstName2(I,First);
	}

	public void SetMiddleName(String Middle) {
		mdSetMiddleName(I,Middle);
	}

	public void SetMiddleName2(String Middle) {
		mdSetMiddleName2(I,Middle);
	}

	public void SetLastName(String Last) {
		mdSetLastName(I,Last);
	}

	public void SetLastName2(String Last) {
		mdSetLastName2(I,Last);
	}

	public void SetSuffix(String Suffix) {
		mdSetSuffix(I,Suffix);
	}

	public void SetSuffix2(String Suffix) {
		mdSetSuffix2(I,Suffix);
	}

	public int Parse() {
		return mdParse(I);
	}

	public int Genderize() {
		return mdGenderize(I);
	}

	public int Salutate() {
		return mdSalutate(I);
	}

	public String GetStatusCode() {
		return mdGetStatusCode(I);
	}

	public String GetErrorCode() {
		return mdGetErrorCode(I);
	}

	public String GetChangeCode() {
		return mdGetChangeCode(I);
	}

	public String GetPrefix() {
		return mdGetPrefix(I);
	}

	public String GetPrefix2() {
		return mdGetPrefix2(I);
	}

	public String GetFirstName() {
		return mdGetFirstName(I);
	}

	public String GetFirstName2() {
		return mdGetFirstName2(I);
	}

	public String GetMiddleName() {
		return mdGetMiddleName(I);
	}

	public String GetMiddleName2() {
		return mdGetMiddleName2(I);
	}

	public String GetLastName() {
		return mdGetLastName(I);
	}

	public String GetLastName2() {
		return mdGetLastName2(I);
	}

	public String GetSuffix() {
		return mdGetSuffix(I);
	}

	public String GetSuffix2() {
		return mdGetSuffix2(I);
	}

	public String GetGender() {
		return mdGetGender(I);
	}

	public String GetGender2() {
		return mdGetGender2(I);
	}

	public String GetSalutation() {
		return mdGetSalutation(I);
	}
}